window.BrowserDetect = {
	init: function () {
		this.browser = this.searchString(this.dataBrowser) || "An unknown browser";
		this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| "an unknown version";
		this.OS = this.searchString(this.dataOS) || "an unknown OS";
	},
	searchString: function (data) {
		for (var i=0;i<data.length;i++)	{
			var dataString = data[i].string;
			var dataProp = data[i].prop;
			this.versionSearchString = data[i].versionSearch || data[i].identity;
			if (dataString) {
				if (dataString.indexOf(data[i].subString) != -1)
					return data[i].identity;
			}
			else if (dataProp)
				return data[i].identity;
		}
	},
	searchVersion: function (dataString) {
		var index = dataString.indexOf(this.versionSearchString);
		if (index == -1) return;
		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
	},
	dataBrowser: [
		{
			string: navigator.userAgent,
			subString: "Chrome",
			identity: "Chrome"
		},
		{ 	string: navigator.userAgent,
			subString: "OmniWeb",
			versionSearch: "OmniWeb/",
			identity: "OmniWeb"
		},
		{
			string: navigator.vendor,
			subString: "Apple",
			identity: "Safari",
			versionSearch: "Version"
		},
		{
			prop: window.opera,
			identity: "Opera"
		},
		{
			string: navigator.vendor,
			subString: "iCab",
			identity: "iCab"
		},
		{
			string: navigator.vendor,
			subString: "KDE",
			identity: "Konqueror"
		},
		{
			string: navigator.userAgent,
			subString: "Firefox",
			identity: "Firefox"
		},
		{
			string: navigator.vendor,
			subString: "Camino",
			identity: "Camino"
		},
		{		// for newer Netscapes (6+)
			string: navigator.userAgent,
			subString: "Netscape",
			identity: "Netscape"
		},
		{
			string: navigator.userAgent,
			subString: "MSIE",
			identity: "Explorer",
			versionSearch: "MSIE"
		},
		{
			string: navigator.userAgent,
			subString: "Gecko",
			identity: "Mozilla",
			versionSearch: "rv"
		},
		{ 		// for older Netscapes (4-)
			string: navigator.userAgent,
			subString: "Mozilla",
			identity: "Netscape",
			versionSearch: "Mozilla"
		}
	],
	dataOS : [
		{
			string: navigator.platform,
			subString: "Win",
			identity: "Win"
		},
		{
			string: navigator.platform,
			subString: "Mac",
			identity: "Mac"
		},
		{
			   string: navigator.userAgent,
			   subString: "iPhone",
			   identity: "iPhone/iPod"
	    },
		{
			string: navigator.platform,
			subString: "Linux",
			identity: "Linux"
		}
	]

};
BrowserDetect.init();

$(document).ready(function() {

	//hover followers icons
	$('.followers').children('.rss').hover(function(){
		
		$(this).find('.howMany').stop(true,true).animate({
			color: '#f8a743'
		}, 200);
	}, function(){
		
		$(this).find('.howMany').stop(true,true).animate({
			color: '#6d6e71'
		}, 200);
	});
	
	$('.followers').children('.twitter').hover(function(){
		
		$(this).children('.following').children('.howMany').stop(true,true).animate({
			'color': '#75d3f0'
		}, 200);
	}, function(){
		
		$(this).children('.following').children('.howMany').stop(true,true).animate({
			'color': '#6d6e71'
		}, 200);
	});

	//create overlayer for class add-hover-blog	
	$('.add-hover-blog').each(function(){
		if (!$(this).parent().find('.add-hover-result')){
			var width = 0;
			if ($(this).parent().parent().parent().hasClass('style-1') || $(this).parent().parent().hasClass('style-1') ) width = '504px';
			if ($(this).parent().parent().parent().hasClass('style-2')) width = '582px';

			$(this).width(width);
			//add hover layer
			$(this).parent().append('<div class="add-hover-result"></div>');
			$(this).parent().children('.add-hover-result').css({
				'position': 'absolute',
				'width': width,
				'height': '226px',
				'z-index': 5,
				'background': '#FFF',
				'top': '4px',
				'opacity': 0,
				'filter': 'alpha(opacity=0)',
				'margin': $(this).css('padding-left')
			});
			
			$(this).parent().children('.add-hover-result').unbind('click');
			$(this).parent().children('.add-hover-result').click(function(){
				window.location = $(this).parent().children('a').attr('href');
			});
			
			//hover handlers
			$(this).parent().hover(function(){
				$(this).children('.add-hover-result').animate({
					'opacity': .4
				}, 500);
			}, function(){
				$(this).children('.add-hover-result').animate({
					'opacity': 0
				}, 500);
			});
		} else return 0;
	});
	
	
	
			
	$('.recent-item').each(function(){
		$(this).hover(function(){
			$(this).children('.recent-pic').animate({
				borderTopColor: '#3fa8bf',
				borderBottomColor: '#3fa8bf',
				borderRightColor: '#3fa8bf',
				borderLeftColor: '#3fa8bf'
			}, 300);
			$(this).find('.title').animate({
				'color': '2px solid #3fa8bf'
			}, 300);
		}, function(){
			$(this).children('.recent-pic').animate({
				borderTopColor: '#edeeee',
				borderBottomColor: '#edeeee',
				borderRightColor: '#edeeee',
				borderLeftColor: '#edeeee'
			}, 300);
			$(this).find('.title').animate({
				'color': '2px solid #6d6e71'
			}, 300);
		});
	});

	//When page loads...
	$(".tab_content").hide(); //Hide all content
	$("ul.tabs li:first").addClass("active").show(); //Activate first tab
	$(".tab_content:first").show(); //Show first tab content

	//On Click Event
	$("ul.tabs li").click(function() {

		$("ul.tabs li").removeClass("active"); //Remove any "active" class
		$(this).addClass("active"); //Add "active" class to selected tab
		$(".tab_content").hide(); //Hide all tab content

		var activeTab = $(this).find("a").attr("href"); //Find the href attribute value to identify the active tab + content
		$(activeTab).fadeIn(); //Fade in the active ID content
		return false;
	});

});