(function($) {
	$.fn.sorted = function(customOptions) {
		var options = {
			reversed: false,
			by: function(a) {
				return a.text();
			}
		};
		$.extend(options, customOptions);
	
		$data = $(this);
		arr = $data.get();
		arr.sort(function(a, b) {
			
		   	var valA = options.by($(a));
		   	var valB = options.by($(b));
			if (options.reversed) {
				return (valA < valB) ? 1 : (valA > valB) ? -1 : 0;				
			} else {		
				return (valA < valB) ? -1 : (valA > valB) ? 1 : 0;	
			}
		});
		return $(arr);
	};

})(jQuery);

$(function() {
  
  var read_button = function(class_names) {
    var r = {
      selected: false,
      type: 0
    };
    for (var i=0; i < class_names.length; i++) {
      if (class_names[i].indexOf('selected-') == 0) {
        r.selected = true;
      }
      if (class_names[i].indexOf('segment-') == 0) {
        r.segment = class_names[i].split('-')[1];
      }
    };
    return r;
  };
  
  var determine_sort = function($buttons) {
    var $selected = $buttons.parent().filter('[class*="selected-"]');
    return $selected.find('a').attr('data-value');
  };
  
  var determine_kind = function($buttons) {
    var $selected = $buttons.parent().filter('[class*="selected-"]');
    return $selected.find('a').attr('data-value');
  };
  
  var $preferences = {
    duration: 800,
    easing: 'easeInOutQuad',
    adjustHeight: false
  };
  
  var $list = $('#list');
  var $data = $list.clone();
  
  var $controls = $('ul.splitter ul');
  
  $controls.each(function(i) {
    
    var $control = $(this);
    var $buttons = $control.find('a');
    
    $buttons.bind('click', function(e) {
    	
  
      var $button = $(this);
      var $button_container = $button.parent();
      var button_properties = read_button($button_container.attr('class').split(' '));      
      var selected = button_properties.selected;
      var button_segment = button_properties.segment;

      if (!selected) {

        $buttons.parent().removeClass('selected-0').removeClass('selected-1').removeClass('selected-2');
        $button_container.addClass('selected-' + button_segment);
        
        var sorting_type = determine_sort($controls.eq(1).find('a'));
        var sorting_kind = determine_kind($controls.eq(0).find('a'));
        
        if (sorting_kind == 'all') {
          var $filtered_data = $data.find('li');
        } else {
          var $filtered_data = $data.find('li.' + sorting_kind);
        }
        
        var $sorted_data = $filtered_data.sorted({
          by: function(v) {
          	var pid = $(v).attr("id").split('_');
            return parseFloat(pid[1]);
          }
        });
       
        
        $list.quicksand($sorted_data, $preferences, function(){
        	portfolio_effect();
        	$('.img-loader-container .img-loader').each(function(){
						$(this).animate({
							'opacity':1
						}, 1000);	});
						
						//add-hover handlers 	
	
	//hover with magnifying glass
	$('.add-hover-magnify').each(function(){
		//add hover layer
		$(this).parent().append('<div class="add-hover-result"></div>');
		$(this).parent().children('.add-hover-result').css({
			'width': $(this).width()+'px',
			'height': $(this).height()+'px',
			'position': 'absolute',
			'z-index': 5,
			'background': '#000',
			'top': 0,
			'opacity': 0,
			'filter': 'alpha(opacity=0)',
			'margin': $(this).css('padding-left')
		});
		//add magnifying glass
		$(this).parent().append('<div class="magnify"><a href="#" rel="prettyPhoto"><img src="img/lupa.png" alt=""></a></div>');
		$(this).parent().children('.magnify').css({
			'position': 'absolute',
			'bottom': 3,
			'right': 5,
			'width': '24px',
			'height': '18px',
			'opacity': 0,
			'filter': 'alpha(opacity=0)',
			'z-index': 20,
			'overflow': 'hidden'
		});
		$(this).parent().children('.magnify').children('a').attr('href', $(this).attr('src') );
		$(this).parent().children('.magnify').children('a').children('img').css({
			'margin-top': '-18px'
		});
		$(this).parent().children('.magnify').children('a').children('img').hover(function(){
			$(this).css('cursor','pointer');
			$(this).stop(true,true).animate({
				'margin-top': 0
			}, 120);
		}, function(){
			$(this).css('cursor','arrow');
			$(this).stop(true,true).animate({
				'margin-top': '-18px'
			}, 120);
		});
		//add more-info icon
		$(this).parent().append('<div class="more-info"><img src="img/moreinfo.png" alt=""></div>');
		$(this).parent().children('.more-info').css({
			'position': 'absolute',
			'bottom': 3,
			'right': 30,
			'width': '24px',
			'height': '18px',
			'opacity': 0,
			'filter': 'alpha(opacity=0)',
			'z-index': 20,
			'overflow': 'hidden'
		});
		$(this).parent().children('.more-info').children('img').css({
			'margin-top': '-18px'
		});
		$(this).parent().children('.more-info').children('img').hover(function(){
			$(this).css('cursor','pointer');
			$(this).stop(true,true).animate({
				'margin-top': 0
			}, 120);
		}, function(){
			$(this).css('cursor','arrow');
			$(this).stop(true,true).animate({
				'margin-top': '-18px'
			}, 120);
		});
		//hover handlers
		$(this).parent().hover(function(){
			$(this).stop(true,true).children('.add-hover-result').animate({
				'opacity': .8
			}, 500);
			$(this).stop(true,true).children('.description').animate({
				'bottom': 0
			}, {
				duration: 300,
				easing: 'easeInOutExpo'
			});
			$(this).children('.magnify').stop(true,true).animate({
				'opacity': 1
			}, 500);
			$(this).children('.more-info').stop(true,true).animate({
				'opacity': 1
			}, 500);
		}, function(){
			$(this).children('.add-hover-result').stop(true,true).animate({
				'opacity': 0
			}, 500);
			$(this).children('.description').stop(true,true).animate({
				'bottom': -20
			}, {
				duration: 300,
				easing: 'easeInOutExpo'
			});
			$(this).children('.magnify').stop(true,true).animate({
				'opacity': 0
			}, 500);
			$(this).children('.more-info').stop(true,true).animate({
				'opacity': 0
			}, 500);
		});
	});
        });
        
        
      }
      
      e.preventDefault();
    });
    
  }); 

  var high_performance = true;  
  var $performance_container = $('#performance-toggle');
  var $original_html = $performance_container.html();
  
  $performance_container.find('a').live('click', function(e) {
    if (high_performance) {
      $preferences.useScaling = false;
      $performance_container.html('CSS3 scaling turned off. Try the demo again. <a href="#toggle">Reverse</a>.');
      high_performance = false;
    } else {
      $preferences.useScaling = true;
      $performance_container.html($original_html);
      high_performance = true;
    }
    e.preventDefault();
  });
});

function portfolio_effect(){

$(document).ready(function(){
	/* FUNCTION FOR SHOW MORE INFO AND GO BACK ON PROJECTS PAGE .Designare.*/
	$(".openproject").css("display", "none");
	$("#projectmoreinfo").css("display", "none");
		
		$('.openproject div.project_content').each(function(){
		  $(this).css("display", "none");
		});
	
	
		$('ul.tj_gallery li').click(function() {
			
		 	 var totalproject = 0;	
		  
			  //Hide projects thumbnails
			  $('.gallery_projects').css("display", "none");
			  
			  //Hide all projects info content
			  $('.openproject div.project_content').each(function(){
			  	$(this).css("display", "none");
			  	totalproject++;
			  });
				
	
			  //Show only the project content that as been clicked with fadein effect
			  if($(this).hasClass("project_0"))
			  		var projectid = "project_1";
			  else
				  	var projectid = $(this).attr('id');
			  var id = projectid.split('_');
			  var prevproj = parseInt(id[1])-1;
			  var nextproj = parseInt(id[1])+1;
		 	
		 	//Prepare the arrows to change to previous or next project
		 	if(prevproj <= 0){
		 		$('span.css_prev').css('opacity', '.3');
		 		$('.proj_prev').css('display', 'none');
		 		$('span.css_prev').css('display', '');
		 	}
		 	else{
		 		$('span.css_prev').css('opacity', '1');
		 		$('.proj_prev').css('display', '');
		 		$('span.css_prev').css('display', 'none');
		 	}		  	

		  if(nextproj == (totalproject + 1)){
		 		$('span.css_next').css('opacity', '.3');
		 		$('.proj_next').css('display', 'none');
		 		$('span.css_next').css('display', '');
		  }
		 	else{
		 		$('span.css_next').css('opacity', '1');
		 		$('.proj_next').css('display', '');
		 		$('span.css_next').css('display', 'none');
		 	}
		  
		  $(".proj_prev").attr("id", "project_"+prevproj);
		  $(".proj_next").attr("id", "project_"+nextproj);
		  
		  
		  //Open project
		  $("#divnav"+projectid).fadeToggle("slow", "linear");
		  $("#projectmoreinfo").css("display", "");
		  $("#proj_navigation").css("display", "");
		  $(".openproject").css("display", "");
		  
		});
		
		$('.backthumbs').click(function() {
				
		  $("#proj_navigation").css("display", "none");
		  $(".openproject").css("display", "none");
		  $("#projectmoreinfo").css("display", "none");
		  
		  $('.gallery_projects').fadeToggle("slow", "linear");
		  
		});
		
					  
		  $('.projectnav a.css_prev, .projectnav a.css_next').click(function() {
		  	var totalproject=0;
		  	
		  	//Hide all projects info content
			  $('.openproject div.project_content').each(function(){
			  	$(this).css("display", "none");
			  	totalproject++;
			  });
			  
			  var projectid = $(this).attr('id');
			  var id = projectid.split('_');
			  var prevproj = parseInt(id[1])-1;
		  	var nextproj = parseInt(id[1])+1;
			  
		 	if(prevproj <= 0){
		 		$('span.css_prev').css('opacity', '.3');
		 		$('.proj_prev').css('display', 'none');
		 		$('span.css_prev').css('display', '');
		 	}
		 	else{
		 		$('span.css_prev').css('opacity', '1');
		 		$('.proj_prev').css('display', '');
		 		$('span.css_prev').css('display', 'none');
		 	}		  	

		  if(nextproj == (totalproject + 1)){
		 		$('span.css_next').css('opacity', '.3');
		 		$('.proj_next').css('display', 'none');
		 		$('span.css_next').css('display', '');
		  }
		 	else{
		 		$('span.css_next').css('opacity', '1');
		 		$('.proj_next').css('display', '');
		 		$('span.css_next').css('display', 'none');
		 	}
 	
	 		$(".proj_prev").attr("id", "project_"+prevproj);
		  $(".proj_next").attr("id", "project_"+nextproj);
		 
		  
		  //Open project
		  $("#divnav"+projectid).fadeToggle("slow", "linear");
		  $("#proj_navigation").css("display", "");
		  $(".openproject").css("display", "");
		  $("#projectmoreinfo").css("display", "");

		  });

	/*END MORE INFO PROJECTS*/
});
}